#include "level.h"
const int TS = 32;
int gemtable [] = {0, 0, 1, 1, 2, 3, 9, 4, 4, 5, 8, 6, 0, 0, 1, 1, 2, 3, 9, 4, 4, 5, 8, 6, 7, 0, 1, 1, 2, 3, 9, 4, 4, 5, 8, 6};
LandSpriteType* get_tile(str name) {
    Game * game = game_global();
    if (! game->tiles) {
        game->tiles = land_hash_new();
    }
    LandSpriteType * st = land_hash_get(game->tiles, name);
    if (st) {
        return st;
    }
    st = get_animation_type(name, 0 /* is_player */);
    LandAnimation * anim = land_spritetype_animation_get_animation(st);
    land_animation_shift(anim, - 32, - 32);
    st->x = 0;
    st->y = 0;
    st->h = 1;
    st->w = TS;
    if (land_equals(name, "bush2pf")) {
        st->w = TS * 2;
        land_animation_shift(anim, - 32, - 32) /* adds to the above */;
    }
    if (land_equals(name, "doorpf")) {
        st->w = 32;
        st->x = - 16;
        st->y = - 32;
        ((LandSpriteTypeAnimation *) st)->auto_speed = 0;
        land_animation_shift(anim, - 32, - 32);
    }
    land_hash_insert(game->tiles, name, st);
    return st;
}
void put_tile(str name, int x, int y, TileType sid) {
    Game * game = game_global();
    Persist * gc = game->current;
    LandSprite * sprite = land_sprite_animated_new(get_tile(name));
    sprite->sx = TS / 64.0;
    sprite->sy = TS / 64.0;
    sprite->sid = sid;
    land_sprite_place_into_grid(sprite, gc->tiles_grid, x * TS, y * TS);
}
void put_animated(str name, int x, int y, int sid, float scale) {
    Game * game = game_global();
    Persist * gc = game->current;
    LandSprite * sprite = land_sprite_animated_new(get_animation_type(name, 0 /* is_player */));
    sprite->sx = scale;
    sprite->sy = scale;
    sprite->sid = sid;
    land_sprite_place_into_grid(sprite, gc->tiles_grid, x * TS + TS / 2, y * TS + TS / 2);
    if (sid >= GemDeep01 && sid <= GemHigh12) {
        gc->gem_count += 1;
        int i = sid - GemDeep01;
        int gv = gemtable [i];
        gc->gems [gv] += 1;
    }
}
LandYaml* level_load(str n) {
    char * name = land_str("level%s.json", n);
    LandYaml * yaml = land_yaml_load(name);
    if (! yaml) {
        print("Could not read %s", name);
    }
    land_free(name);
    return yaml;
}
bool level_new(str num) {
    Game * game = game_global();
    if (! game->persist) {
        game->persist = land_hash_new();
    }
    Persist * persist = land_hash_get(game->persist, num);
    if (persist) {
        if (game->current) {
            player_unplace(game->current->player);
        }
        game->previous = game->current;
        game->current = persist;
        return 1;
    }
    LandYaml * yaml = level_load(num);
    if (! yaml) {
        return 0;
    }
    land_alloc(persist);
    persist->level_number = num;
    game->idle = - 60 * 7;
    if (game->current) {
        player_unplace(game->current->player);
    }
    game->previous = game->current;
    game->current = persist;
    land_hash_insert(game->persist, num, persist);
    persist->level = land_map_new();
/*
    land_array_clear(game.players)
    land_array_clear(game.removed_players)
*/
    level_place_from_yaml(yaml);
    level_place_background();
    script_init_for_level();
    return 1;
}
void level_place_from_yaml(LandYaml * yaml) {
    Game * game = game_global();
    Persist * gc = game->current;
    gc->left_door = 0;
    gc->level_name = "";
    int w = land_yaml_get_entry_int(yaml->root, "width");
    int h = land_yaml_get_entry_int(yaml->root, "height");
    LandYamlEntry * props = land_yaml_get_entry(yaml->root, "properties");
    for (int i = 0; i < 100; i += 1) {
        LandYamlEntry * prop = land_yaml_get_nth(props, i);
        if (! prop) {
            break;
        }
        str key = land_yaml_get_entry_scalar(prop, "name");
        if (land_equals(key, "left_door")) {
            gc->left_door = land_yaml_get_entry_dup(prop, "value");
        }
        if (land_equals(key, "right_door")) {
            gc->right_door = land_yaml_get_entry_dup(prop, "value");
        }
        else if (land_equals(key, "name")) {
            gc->level_name = land_yaml_get_entry_scalar(prop, "value");
        }
        else if (land_equals(key, "background")) {
            gc->background = land_yaml_get_entry_scalar(prop, "value");
        }
    }
    gc->tiles_grid = land_sprites_grid_new(32, 32, w, h);
    LandLayer * tlayer = land_layer_new_with_grid(gc->tiles_grid);
    land_map_add_layer(gc->level, tlayer);
    gc->sprites_grid = land_sprites_grid_new(32, 32, w, h);
    LandLayer * slayer = land_layer_new_with_grid(gc->sprites_grid);
    land_map_add_layer(gc->level, slayer);
    LandYamlEntry * layers = land_yaml_get_entry(yaml->root, "layers");
    int li = 0;
    while (1) {
        LandYamlEntry * layer = land_yaml_get_nth(layers, li);
        if (! layer) {
            break;
        }
        str name = land_yaml_get_entry_scalar(layer, "name");
        LandYamlEntry * data = land_yaml_get_entry(layer, "data");
        for (int y = 0; y < h; y += 1) {
            for (int x = 0; x < w; x += 1) {
                Player * p = NULL;
                int i = x + y * w;
                int tile = land_yaml_get_nth_int(data, i);
                int sx = x * TS + TS / 2;
                int sy = y * TS + TS - 1;
                if (tile == 1) {
                    put_tile("branch", x, y, Root);
                }
                else if (tile == 2) {
                    p = player_make(PlayerWitch, sx, sy);
                    if (game->previous) {
                        player_transfer(p, game->previous->player);
                    }
                }
                else if (tile == 3) {
                    put_tile("bush2pf", x, y, Bush);
                }
                else if (tile == 4) {
                    put_tile("bushpf", x, y, Platform);
                }
                else if (tile == 5) {
                    p = player_make(PlayerBumblebee, sx, y * TS + TS / 2);
                }
                else if (tile == 6) {
                    player_make(PlayerPyramidtree, sx, sy);
                }
                else if (tile == 7) {
                    put_animated("ruby", x, y, Ruby01, 0.5);
                }
                else if (tile == 8) {
                    put_animated("beryl", x, y, Beryl03, 0.5);
                }
                else if (tile == 9) {
                    put_animated("citrine", x, y, Citrine05, 0.5);
                }
                else if (tile == 10) {
                    put_animated("emerald", x, y, Emerald06, 0.5);
                }
                else if (tile == 11) {
                    put_animated("aquamarine", x, y, Aquamarine08, 0.5);
                }
                else if (tile == 12) {
                    put_animated("sapphire", x, y, Sapphire10, 0.5);
                }
                else if (tile == 13) {
                    put_animated("amethyst", x, y, Amethyst12, 0.5);
                }
                else if (tile == 14) {
                    put_animated("diamond2", x, y, Diamond01, 0.5);
                }
                else if (tile == 15) {
                    put_tile("doorpf", x, y, Door);
                    if (x < land_div(w, 2)) {
                        gc->entry_x = x * TS + TS;
                        gc->entry_y = y * TS + TS - 1;
                    }
                    else {
                        gc->exit_x = x * TS + TS;
                        gc->exit_y = y * TS + TS - 1;
                    }
                }
                else if (tile == 16) {
                    put_animated("carnelian", x, y, Carnelian07, 0.5);
                }
                else if (tile == 17) {
                    put_animated("opal", x, y, Opal11, 0.5);
                }
                else if (tile == 18) {
                    p = player_make(PlayerOpossum, sx, sy);
                }
                else if (tile == 19) {
                    p = player_make(PlayerWoodPecker, sx, sy);
                }
                else if (tile == 20) {
                    p = player_make(PlayerBeaver, sx, sy);
                }
                else if (tile == 21) {
                    p = player_make(PlayerRacoon, sx, sy);
                }
                else if (tile == 22) {
                    p = player_make(PlayerSkunk, sx, sy);
                }
                else if (tile == 23) {
                    p = player_make(PlayerFox, sx, sy);
                }
                else if (tile == 24) {
                    put_animated("heart_subdiv", x, y, Heart, 0.5);
                }
                else if (tile == 25) {
                    put_tile("tilepf", x, y, Tile);
                }
                else if (tile == 26) {
                    p = player_make(PlayerVillain, sx, sy);
                }
                else if (tile == 27) {
                    put_tile("boardpf", x, y, Board);
                }
                else if (tile == 28) {
                    put_animated("ruby", x, y, Ruby02, 0.5);
                }
                else if (tile == 29) {
                    put_animated("beryl", x, y, Beryl04, 0.5);
                }
                else if (tile == 30) {
                    put_animated("aquamarine", x, y, Aquamarine09, 0.5);
                }
                else if (tile == 31) {
                    put_animated("diamond", x, y, GemHigh02, 0.5);
                }
                else if (tile == 32) {
                    put_animated("beryl", x, y, GemHigh03, 0.5);
                }
                else if (tile == 33) {
                    put_animated("beryl", x, y, GemHigh04, 0.5);
                }
                else if (tile == 34) {
                    put_animated("citrine", x, y, GemHigh05, 0.5);
                }
                else if (tile == 35) {
                    put_animated("emerald", x, y, GemHigh06, 0.5);
                }
                else if (tile == 36) {
                    put_animated("carnelian", x, y, GemHigh07, 0.5);
                }
                else if (tile == 37) {
                    put_animated("aquamarine", x, y, GemHigh08, 0.5);
                }
                else if (tile == 38) {
                    put_animated("aquamarine", x, y, GemHigh09, 0.5);
                }
                else if (tile == 39) {
                    put_animated("sapphire", x, y, GemHigh10, 0.5);
                }
                else if (tile == 40) {
                    put_animated("opal", x, y, GemHigh11, 0.5);
                }
                else if (tile == 41) {
                    put_animated("amethyst", x, y, GemHigh12, 0.5);
                }
                else if (tile == 42) {
                    put_animated("ruby", x, y, GemDeep01, 0.5);
                }
                else if (tile == 43) {
                    put_animated("ruby", x, y, GemDeep02, 0.5);
                }
                else if (tile == 44) {
                    put_animated("beryl", x, y, GemDeep03, 0.5);
                }
                else if (tile == 45) {
                    put_animated("beryl", x, y, GemDeep04, 0.5);
                }
                else if (tile == 46) {
                    put_animated("citrine", x, y, GemDeep05, 0.5);
                }
                else if (tile == 47) {
                    put_animated("emerald", x, y, GemDeep06, 0.5);
                }
                else if (tile == 48) {
                    put_animated("carnelian", x, y, GemDeep07, 0.5);
                }
                else if (tile == 49) {
                    put_animated("aquamarine", x, y, GemDeep08, 0.5);
                }
                else if (tile == 50) {
                    put_animated("aquamarine", x, y, GemDeep09, 0.5);
                }
                else if (tile == 51) {
                    put_animated("sapphire", x, y, GemDeep10, 0.5);
                }
                else if (tile == 52) {
                    put_animated("opal", x, y, GemDeep11, 0.5);
                }
                else if (tile == 53) {
                    put_animated("amethyst", x, y, GemDeep12, 0.5);
                }
                else if (tile == 54) {
                    player_make(PlayerAardvark, sx, sy);
                }
                else if (tile == 55) {
                    player_make(PlayerAnteater, sx, sy);
                }
                else if (tile == 100) {
                    ;
                }
                else if (tile != 0) {
                    print("Error: unknown tile %d at %d/%d", tile, x, y);
                }
                if (p && land_equals(name, "left facing")) {
                    player_flip(p);
                }
            }
        }
        li += 1;
    }
}
void level_place_background(void) {
    Game * game = game_global();
    Persist * gc = game->current;
    LandGrid * grid_back;
    int gw = land_grid_width(gc->tiles_grid);
    int gh = land_grid_height(gc->tiles_grid);
    int paw = 800 + (gw - 800) / 2.0;
    int pah = 450 + (gh - 450) / 2.0;
    int bw = ceil(paw / 450.0);
    int bh = ceil(pah / 450.0);
    grid_back = land_tilegrid_new(450, 450, bw, bh);
    if (! gc->background) {
        gc->background = "m1e2e3e0e1m2m3m0";
    }
    int n = land_div(strlen(gc->background), 2);
    int i = 0;
    for (int x = 0; x < bw; x += 1) {
        for (int y = 0; y < bh; y += 1) {
            char s [3];
            s [0] = gc->background [i * 2 + 0];
            s [1] = gc->background [i * 2 + 1];
            s [2] = 0;
            land_tilegrid_place(grid_back, x, y, get_background(s));
            i += 1;
            i %= n;
        }
    }
    LandLayer * layer_back = land_layer_new_with_grid(grid_back);
    land_layer_set_scroll_speed(layer_back, 0.5, 0.5);
    float bs = 450.0 / land_image_height(get_background("m0"));
    grid_back->draw_scale_x = bs;
    grid_back->draw_scale_y = bs;
    land_map_add_layer_back(gc->level, layer_back);
}
void load_sound(str name) {
    Game * game = game_global();
    if (! game->sounds) {
        game->sounds = land_array_new();
    }
    char * name2 = land_str("audio/%s.ogg", name);
    LandSound * sound = land_sound_load(name2);
    if (! sound) {
        print("ERROR: Could not load %s", name2);
    }
    land_free(name2);
    land_array_add(game->sounds, sound);
}
void stream_sound(str name) {
    char * name2 = land_str("audio/%s.ogg", name);
    land_stream_music(NULL, name2);
    land_free(name2);
}
void load_audio(void) {
    stream_sound(start_music);
    load_sound("ding-01");
    load_sound("ding-02");
    load_sound("ding-03");
    load_sound("ding-04");
    load_sound("ding-05");
    load_sound("ding-06");
    load_sound("ding-07");
    load_sound("ding-08");
    load_sound("ding-09");
    load_sound("ding-10");
    load_sound("ding-11");
    load_sound("ding-12");
    load_sound("ding-13");
    load_sound("ding-14");
    load_sound("ding-15");
    load_sound("ding-16");
    load_sound("ding-17");
    load_sound("ding-18");
    load_sound("ding-19");
    load_sound("ding-20");
    load_sound("ding-21");
    load_sound("ding-22");
    load_sound("ding-23");
    load_sound("ding-24");
    load_sound("ding-25");
    load_sound("ding-26");
    load_sound("ding-27");
    load_sound("ding-28");
    load_sound("ding-29");
    load_sound("ding-30");
    load_sound("ding-31");
    load_sound("ding-32");
    load_sound("ding-33");
    load_sound("ding-34");
    load_sound("ding-35");
    load_sound("ding-36");
    load_sound("jump");
    load_sound("scream2");
    load_sound("no");
    load_sound("healed1");
    load_sound("heal");
    load_sound("slime_02");
    load_sound("door_01");
    load_sound("Socapex - blub_hurt");
    load_sound("doorclose");
    load_sound("fireball");
    load_sound("icicle");
    load_sound("rootspell");
    load_sound("ability_electricpulse");
}
void play(AudioFile af, float vol, float pan, float speed) {
    Game * game = game_global();
    LandSound * s = land_array_get(game->sounds, af);
    land_sound_play(s, vol, pan, speed);
}
